<?php
/*--------------------------------------------------------------------
 CombisIdDtoCollection.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO;

use ArrayAccess;
use Countable;
use InvalidArgumentException;
use Iterator;
use JsonSerializable;

/**
 * Class CombisIdDtoCollection
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO
 */
class CombisIdDtoCollection implements Countable, Iterator, ArrayAccess, JsonSerializable
{
    
    /**
     * @var CombisIdDto[]
     */
    protected $values = [];
    
    /**
     * @var int
     */
    protected $position = 0;
    
    /**
     * SellingUnitImagesCollection constructor.
     *
     * @param CombisIdDto[] $images
     */
    public function __construct(array $images = [])
    {
        if (count($images)) {
            
            foreach ($images as $image) {
                
                $this[] = $image;
            }
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function current(): CombisIdDto
    {
        return $this->values[$this->position];
    }
    
    
    /**
     * @inheritDoc
     */
    public function next(): void
    {
        $this->position++;
    }
    
    
    /**
     * @inheritDoc
     */
    public function key(): int
    {
        return $this->position;
    }
    
    
    /**
     * @inheritDoc
     */
    public function valid(): bool
    {
        return isset($this->values[$this->position]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function rewind(): void
    {
        $this->position = 0;
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetExists($offset): bool
    {
        return isset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetGet($offset)
    {
        return $this->values[$offset];
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetSet($offset, $value): void
    {
        if (!$value instanceof CombisIdDto) {
            
            throw new InvalidArgumentException(static::class . ' only accepts ' . CombisIdDto::class);
        }
        
        if (empty($offset)) {
            $this->values[] = $value;
        } else {
            $this->values[$offset] = $value;
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetUnset($offset): void
    {
        unset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function count(): int
    {
        return count($this->values);
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize()
    {
        return $this->values;
    }
}